// ChildView.cpp : CChildView NX̓̒`s܂B
//

#include "stdafx.h"
#include "sermon.h"
#include "ChildView.h"

#include "XrateRaw.h"
#include "XrateHex.h"
#include "XrateBin.h"
#include "XrateSL.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	threshold=20000;
	hCom=0;
	strcpy(ComPort,"");
	BaudRate=0;

	lovf=0;
	SendTranslate=new CXrateRaw(this);
	RecvTranslate=new CXrateRaw(this);
}

CChildView::~CChildView()
{
	ContinueThread=FALSE;
	Sleep(400);
	if(hCom)
		ComClose();
	delete SendTranslate;
	delete RecvTranslate;
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_WM_SHOWWINDOW()
	ON_WM_SIZE()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(IDSENDCMD, OnSendcmd)
	ON_MESSAGE(WM_USER,OnReceiveMessage)
	ON_COMMAND(ID_CLEAR_REPORT, OnClearReport)
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_REPORT_CR, OnReportCr)
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView bZ[W nh

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// TODO: bZ[W nh̃R[hɒǉĂB
	
	// `̂߂ CWnd::OnPaint ĂяoĂ͂܂B
}


void CChildView::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CWnd ::OnShowWindow(bShow, nStatus);
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	//edit_wnd.ShowWindow(SW_SHOW);
}

BOOL CChildView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	BOOL r= CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
	RECT crect;
	this->GetClientRect(&crect);
	RECT cmdrect=crect;
	cmdrect.top=cmdrect.bottom-30;
	if(cmdrect.top<cmdrect.bottom) cmdrect.top=cmdrect.bottom;
	RECT rptrect=crect;
	rptrect.bottom=cmdrect.top;
//	lb_wnd.SetFocus();
	cmd_wnd.Create(ES_MULTILINE|ES_AUTOHSCROLL|WS_VISIBLE|WS_CHILD|WS_BORDER,cmdrect,this,49331);	
	cmd_wnd.SetFocus();
	rpt_wnd.Create(ES_MULTILINE|ES_READONLY|ES_NOHIDESEL|WS_VSCROLL|WS_HSCROLL|WS_VISIBLE|WS_CHILD,rptrect,this,49332);	
	// ̓KȃtHg𐻍, ŏ̈tHgTCY
	ttFont.CreateFont(-16,0,0,0,0,0,0, 0,ANSI_CHARSET,OUT_RASTER_PRECIS,CLIP_CHARACTER_PRECIS,DEFAULT_QUALITY,FIXED_PITCH|FF_DONTCARE,NULL);
	rpt_wnd.SetFont(&ttFont);
	CreateReceiveThread();
	return r;
}

void CChildView::OnSize(UINT nType, int cx, int cy) 
{
	CWnd ::OnSize(nType, cx, cy);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	RECT crect;
	this->GetClientRect(&crect);
	RECT cmdrect=crect;
	cmdrect.top=cmdrect.bottom-30;
	if(cmdrect.top<0) cmdrect.top=0;
	RECT rptrect=crect;
	rptrect.bottom=cmdrect.top;
	if(cmd_wnd.GetSafeHwnd()!=NULL) 
	{
		cmd_wnd.MoveWindow(&cmdrect,TRUE);
	}
	if(rpt_wnd.GetSafeHwnd()!=NULL) 
	{
		rpt_wnd.MoveWindow(&rptrect,TRUE);
	}
}

BOOL CChildView::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	return CWnd ::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CChildView::OnEditCopy() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	rpt_wnd.Copy();
}


void CChildView::OnEditPaste() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	cmd_wnd.Paste();
}


int CChildView::AddContentToReport(const char *content)
{
	int rl=rpt_wnd.GetWindowTextLength();
	int cl=strlen(content);
	int f=0;
	if(rl+cl>threshold)   // \ʂ̐
	{
		int ln;
		if(50+cl>rl)
			ln=rl;
		else
		{
			ln=rpt_wnd.LineFromChar(threshold/4+cl);  // ؂藎Ƃʒu
			ln++;
			f=ln;
			ln=rpt_wnd.LineIndex(ln);
			if(ln<0) ln=rl;
		}
		int st,en;
		rpt_wnd.GetSel(st,en);
		rpt_wnd.SetSel(0,ln,TRUE);
		rpt_wnd.ReplaceSel("",FALSE);
		st-=ln;  en-=ln;
		if(st<0) st=0;
		if(en>0) rpt_wnd.SetSel(st,en,TRUE);
		f=1;
	}
	// sǉ
	int st,en;
	rpt_wnd.GetSel(st,en);
	rl=rpt_wnd.GetWindowTextLength();
	rpt_wnd.SetSel(rl,rl,FALSE);
	rpt_wnd.ReplaceSel(content,FALSE);
	if(en>0) rpt_wnd.SetSel(st,en,TRUE);
	return f;
}


void CChildView::OnSendcmd() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	int l=cmd_wnd.GetWindowTextLength();
	char *cmd=new char[l+2];
	int r=cmd_wnd.GetWindowText(cmd,l+1);
	cmd[r]='\0';
	CommandParse(cmd);
	delete [] cmd;
	return ;
}


////////////////////////////////////////////////////////////////////////////////////////////////
// MMϊ
/* Ђ
void CChildView::CommandParse(char *command)
{
	AddContentToReport(command);
	AddContentToReport("\r\n");
	ComSend(command);
	ComSend("\r\n");
}

void CChildView::ReceiveParse(char *rcv)
{
	AddContentToReport(rcv);
}*/

void CChildView::CommandParse(char *command)
{
	int len=XRATETDEFAULT;
	char *buff=SendTranslate->XrateTransmit(command,len);
	if(Econt)
	{
		AddContentToReport(">> ");
		AddContentToReport(command);
		AddContentToReport("\r\n");
	}

	if(len==XRATETREPORT)
	{
		AddContentToReport(buff);
		return;
	}
	ComSend(buff,len);

}

void CChildView::ReceiveParse(char *rcv,int len)
{
	char *rept=RecvTranslate->XrateReceive(rcv,len);  // \ȂƂ͂
	if(Rcont)
		AddContentToReport(rept);
}
////////////////////////////////////////////////////////////////////////////////////////////////
// ʐM
int CChildView::ComOpen(char *com)
{
	DCB dcb;
	BOOL fSuccess;

	hCom = CreateFile(com,
    	GENERIC_READ | GENERIC_WRITE,
    	0,    /* comm devices must be opened w/exclusive-access */
    	NULL, /* no security attrs */
    	OPEN_EXISTING, /* comm devices must use OPEN_EXISTING */
    	0,    /* not overlapped I/O */
    	NULL  /* hTemplate must be NULL for comm devices */
    	);

	if (hCom == INVALID_HANDLE_VALUE) {
		char tmp[200];
		sprintf(tmp,"Cannot open communication port '%s'",com);
			MessageBox(tmp,"Sermon::ComOpen",MB_OK);
		hCom=0;
		return -1;
	}

	/*
 	 * Omit the call to SetupComm to use the default queue sizes.
	 * Get the current configuration.
	 */
	fSuccess = GetCommState(hCom, &dcb);

	if (!fSuccess) {
		char tmp[200];
		sprintf(tmp,"Cannot get status of communication port '%s'",com);
		MessageBox(tmp,"Sermon::ComOpen",MB_OK);
		return -1;
	}
	/* Fill in the DCB: baud=9600, 8 data bits, no parity, 1 stop bit. */

	dcb.BaudRate = BaudRate;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;

	fSuccess = SetCommState(hCom, &dcb);

	if (!fSuccess) {
		char tmp[200];
		sprintf(tmp,"Failed to setup communication port '%s'/%d",com,BaudRate);
		MessageBox(tmp,"Sermon::ComOpen",MB_OK);
		return -1;
	}
	// MCxgZbg
    SetCommMask(hCom, EV_RXCHAR);
	// ^CAEgݒ
	COMMTIMEOUTS commtimeouts;
	GetCommTimeouts(hCom,&commtimeouts);
    commtimeouts.ReadIntervalTimeout=25;
    commtimeouts.ReadTotalTimeoutConstant=100;
    commtimeouts.ReadTotalTimeoutMultiplier=0;
	commtimeouts.WriteTotalTimeoutConstant=500;
    commtimeouts.WriteTotalTimeoutMultiplier=20;
	SetCommTimeouts(hCom,&commtimeouts);
	return 0;
}

int CChildView::ComClose()
{
	HANDLE thd=hCom;
	hCom=0;
	Sleep(200);
    CloseHandle(thd);
	return 0;
}

void CChildView::SetupComCondition(char *port, int speed)
{
	if((BaudRate==speed)&&(strcmp(port,ComPort)==0))
		return; // Nothing to do
	ComClose();
	strcpy(ComPort,port);
	BaudRate=speed;
	ComOpen(ComPort);
}

int CChildView::ComSend(char *str,int len)
{
	unsigned long done;
	if(len<0) len=strlen(str);
   	if(WriteFile(hCom,str,len,&done,0)==false)
    {
        MessageBox("Failed to transmit","Sermon::ComSend",MB_OK);
		return -1;
	} 
	else if((int)done!=len)
    {
        MessageBox("Failed to transmit (Time out?)","Sermon::ComSend",MB_OK);
        return -1;
    }
	return 0;
}

LRESULT CChildView::OnReceiveMessage(WPARAM wparam, LPARAM lparam)
{
	char buff[513];
	int ovf=fifo.IsOverflow();
	int sz=fifo.Read(buff,512);
	buff[sz]='\0';
	ReceiveParse(buff,sz);
	if((!lovf)&&(ovf))
	{
		MessageBox("Receive buffer overflowed","Sermon::OnReceive");
		lovf=1;
	}
	return 0;
}

UINT CChildView::RThread(LPVOID pParam)
{
	CChildView *ccv=(CChildView*)pParam;
	HWND wnd=ccv->m_hWnd;
	HANDLE hCom=ccv->hCom;
	Sleep(2000); // ^C~O
	DWORD size=0;
	char buff[512];
	while(ccv->ContinueThread)
	{
		hCom=ccv->hCom;
		if(hCom==0)
		{
			Sleep(100);
			continue;
		}
		if(ReadFile(hCom,buff,512,&size,NULL)!=0)
		{
			if(size!=0)
			{
				ccv->fifo.Write(buff,size);
				::PostMessage(wnd,WM_USER,size,0);
			}
			else
				Sleep(10);
		} 
		else Sleep(10);
   }
	return 0;
}

void CChildView::CreateReceiveThread(void)
{
	ContinueThread=TRUE;
	ReceiveThread=AfxBeginThread(RThread, this);
}


////////////////////////////////////////////////////////////////////////////////////////////////
// tB^Ȃǂ̃j[

void CChildView::OnCxtHex() 
{
	delete SendTranslate;
	SendTranslate=new CXrateHex(this);
}

void CChildView::OnCxrHex() 
{
	delete RecvTranslate;
	RecvTranslate=new CXrateHex(this);
}

void CChildView::OnCxtRaw() 
{
	delete SendTranslate;
	SendTranslate=new CXrateRaw(this);
}


void CChildView::OnCxrRaw() 
{
	delete RecvTranslate;
	RecvTranslate=new CXrateRaw(this);
}

void CChildView::OnCxtBin() 
{
	delete SendTranslate;
	SendTranslate=new CXrateBin(this);
}


void CChildView::OnCxrBin() 
{
	delete RecvTranslate;
	RecvTranslate=new CXrateBin(this);
}

void CChildView::OnCxtSL() 
{
	delete SendTranslate;
	SendTranslate=new CXrateSL(this);
}

void CChildView::OnCxrSL() 
{
	delete RecvTranslate;
	RecvTranslate=new CXrateSL(this);
}

void CChildView::OnCxtSL11()
{
	delete SendTranslate;
	SendTranslate=new CXrateSL11(this);
}

void CChildView::OnCxrSL11()
{
	delete RecvTranslate;
	RecvTranslate=new CXrateSL11(this);
}

void CChildView::OnClearReport() 
{
	rpt_wnd.SetWindowText("");
}

void CChildView::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CWnd ::OnActivate(nState, pWndOther, bMinimized);
	if(nState!=WA_INACTIVE)
		cmd_wnd.SetFocus();	
}

void CChildView::OnReportCr() 
{
	AddContentToReport("\r\n");
}

void CChildView::OnSetFocus(CWnd* pOldWnd) 
{
	CWnd ::OnSetFocus(pOldWnd);
	cmd_wnd.SetFocus();	
}



