// FIFO.cpp: CFIFO NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "sermon.h"
#include "FIFO.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const int FIFOSize=2048;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CFIFO::CFIFO()
{
	buffer=new unsigned char [FIFOSize];
	rp=wp=0;
	ovf=0;
}

CFIFO::~CFIFO()
{
	if(buffer) delete buffer;
	buffer=NULL;
}

int CFIFO::IsOverflow(void)
{
	return ovf;
}

int CFIFO::Write(char *buff, int len)
{
	int rs;
	if(wp-rp==FIFOSize) 
	{ ovf=1;  return 0; }        // ς

	if(FIFOSize-(wp-rp)<len)
	{ len=FIFOSize-(wp-rp); ovf=1; }
	else
		ovf=0;

	rs=len;
	int sbp=wp%FIFOSize;
	int ebp=(wp+len)%FIFOSize;
	if(sbp<ebp)
	{
		memcpy(buffer+sbp,buff,len);
	}
	else
	{
		int half=FIFOSize-sbp;
		memcpy(buffer+sbp,buff,half);
		memcpy(buffer,buff+half,len-half);
	}
	wp+=len;
	return len;
}

int CFIFO::Read(char *buff, int len)
{
	int rs=0;
	if(wp-rp==0)
		return 0;
	if(wp-rp<len) len=wp-rp;
	int sbp=rp%FIFOSize;
	int ebp=(rp+len)%FIFOSize;
	rs=len;
	if(ebp>sbp) 
	{
		memcpy(buff,buffer+sbp,len);
	}
	else 
	{
		int half=FIFOSize-sbp;
		memcpy(buff,buffer+sbp,half);
		memcpy(buff+half,buffer,len-half);
	}
	ovf=0;
	rp+=rs;
	return rs;
}
