// MainFrm.cpp : CMainFrame NX̓̒`s܂B
//

#include "stdafx.h"
#include "sermon.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_CXR_HEX, OnCxrHex)
	ON_COMMAND(ID_CXR_RAW, OnCxrRaw)
	ON_COMMAND(ID_CXT_HEX, OnCxtHex)
	ON_COMMAND(ID_CXT_RAW, OnCxtRaw)
	ON_COMMAND(ID_REnable, OnREnable)
	ON_COMMAND(ID_CXR_BIN, OnCxrBin)
	ON_COMMAND(ID_CXT_BIN, OnCxtBin)
	ON_COMMAND(ID_CXR_SL, OnCxrSl)
	ON_COMMAND(ID_CXT_SL, OnCxtSl)
	ON_COMMAND(ID_CXR_SL11, OnCxrSl11)
	ON_COMMAND(ID_CXT_SL11, OnCxtSl11)
	ON_COMMAND(ID_LOCALECHO, OnLocalecho)
	ON_COMMAND(ID_COMSETUP, OnComsetup)
	ON_COMMAND(ID_SAVEDAFAULT, OnSavedafault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_COMPORT,
	ID_INDICATOR_COMSPEED,
	ID_INDICATOR_ENABLE,
	ID_INDICATOR_RCV,
	ID_INDICATOR_SEND,
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame()
{
	// TODO: ̈ʒuɃȍR[hǉĂB
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// t[̃NCAg̈Ŝ߂r[쐬܂B
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // 쐬Ɏs
	}

	// j[
	LoadSettings();
	//m_wndView.ReceptionControl(TRUE);
	//GetMenu()->CheckMenuItem(ID_REnable,MF_CHECKED|MF_BYCOMMAND);
	//GetMenu()->CheckMenuItem(ID_LOCALECHO,MF_CHECKED|MF_BYCOMMAND);
	//OnCxtRaw(); OnCxrRaw();
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs CāAWindow NXX^C
	//       CĂB

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// r[ EBhEɃtH[JX^܂B
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// r[ɍŏɃR}h@^܂B
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// Ȃꍇɂ̓ftHg̏s܂B
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::SetRcvIndicator(char *s)
{
	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_RCV),s);
}

void CMainFrame::SetSendIndicator(char *s)
{
	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_SEND),s);
}


#define IDT_ST ID_CXT_RAW
#define IDT_EN ID_CXT_SL11
#define IDR_ST ID_CXR_RAW
#define IDR_EN ID_CXR_SL11

const int TransIDR[]={ID_CXR_RAW,ID_CXR_HEX,ID_CXR_BIN,ID_CXR_SL,ID_CXR_SL11,0};
const int TransIDT[]={ID_CXT_RAW,ID_CXT_HEX,ID_CXT_BIN,ID_CXT_SL,ID_CXT_SL11,0};
const int numTrans=5;

void CMainFrame::OnCxtHex() 
{
	GetMenu()->CheckMenuRadioItem(IDT_ST,IDT_EN,ID_CXT_HEX,MF_BYCOMMAND);
	SetSendIndicator("Rx:HEX");
	m_wndView.OnCxtHex();
}
void CMainFrame::OnCxrHex() 
{
	GetMenu()->CheckMenuRadioItem(IDR_ST,IDR_EN,ID_CXR_HEX,MF_BYCOMMAND);
	SetRcvIndicator("Tx:HEX");
	m_wndView.OnCxrHex();
}

void CMainFrame::OnCxtRaw() 
{
	GetMenu()->CheckMenuRadioItem(IDT_ST,IDT_EN,ID_CXT_RAW,MF_BYCOMMAND);
	SetSendIndicator("Rx:Raw");
	m_wndView.OnCxtRaw();
}

void CMainFrame::OnCxrRaw() 
{
	GetMenu()->CheckMenuRadioItem(IDR_ST,IDR_EN,ID_CXR_RAW,MF_BYCOMMAND);
	SetRcvIndicator("Tx:Raw");
	m_wndView.OnCxrRaw();
}

void CMainFrame::OnCxrBin() 
{
	GetMenu()->CheckMenuRadioItem(IDR_ST,IDR_EN,ID_CXR_BIN,MF_BYCOMMAND);
	SetRcvIndicator("Rx:Bin");
	m_wndView.OnCxrBin();
}

void CMainFrame::OnCxtBin() 
{
	GetMenu()->CheckMenuRadioItem(IDT_ST,IDT_EN,ID_CXT_BIN,MF_BYCOMMAND);
	SetSendIndicator("Tx:Bin");
	m_wndView.OnCxtBin();
}

void CMainFrame::OnCxrSl() 
{
	GetMenu()->CheckMenuRadioItem(IDR_ST,IDR_EN,ID_CXR_SL,MF_BYCOMMAND);
	SetRcvIndicator("Rx:SL");
	m_wndView.OnCxrSL();
}

void CMainFrame::OnCxtSl() 
{
	GetMenu()->CheckMenuRadioItem(IDT_ST,IDT_EN,ID_CXT_SL,MF_BYCOMMAND);
	SetSendIndicator("Tx:SL");
	m_wndView.OnCxtSL();
}

void CMainFrame::OnCxrSl11() 
{
	GetMenu()->CheckMenuRadioItem(IDR_ST,IDR_EN,ID_CXR_SL11,MF_BYCOMMAND);
	SetRcvIndicator("Rx:SL11");
	m_wndView.OnCxrSL11();
}

void CMainFrame::OnCxtSl11() 
{
	GetMenu()->CheckMenuRadioItem(IDT_ST,IDT_EN,ID_CXT_SL11,MF_BYCOMMAND);
	SetSendIndicator("Tx:SL11");
	m_wndView.OnCxtSL11();
}

void CMainFrame::OnREnable() 
{
	if(GetMenu()->GetMenuState(ID_REnable,MF_BYCOMMAND)&MF_CHECKED)
	{
		m_wndView.ReceptionControl(FALSE);
		GetMenu()->CheckMenuItem(ID_REnable,MF_UNCHECKED|MF_BYCOMMAND);
		m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_ENABLE),"Rx suspended");
	}
	else
	{
		m_wndView.ReceptionControl(TRUE);
		GetMenu()->CheckMenuItem(ID_REnable,MF_CHECKED|MF_BYCOMMAND);
		m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_ENABLE),"Receiving");
	}	
}



void CMainFrame::OnLocalecho() 
{
	if(GetMenu()->GetMenuState(ID_LOCALECHO,MF_BYCOMMAND)&MF_CHECKED)
	{
		m_wndView.EchobackControl(FALSE);
		GetMenu()->CheckMenuItem(ID_LOCALECHO,MF_UNCHECKED|MF_BYCOMMAND);
	}
	else
	{
		m_wndView.EchobackControl(TRUE);
		GetMenu()->CheckMenuItem(ID_LOCALECHO,MF_CHECKED|MF_BYCOMMAND);
	}
}

void CMainFrame::OnComsetup() 
{
 	setupDlg.DoModal();
	char buff[20];
	sprintf(buff,"%d bps",setupDlg.GetComSpeed());
	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_COMSPEED),buff);
	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_COMPORT),
					setupDlg.GetComPort());
	m_wndView.SetupComCondition(setupDlg.GetComPort(),setupDlg.GetComSpeed());	
}

void CMainFrame::LoadSettings()
{
	CWinApp* pApp = AfxGetApp();

	////////////
	CString port=pApp->GetProfileString(ProfileSection,"comport","COM1");
	int speed=pApp->GetProfileInt(ProfileSection,"comspeed",9600);
	char buff[20]; strcpy(buff,(LPCTSTR)port);
	setupDlg.SetComPort(buff); setupDlg.SetComSpeed(speed);

	sprintf(buff,"%d bps",setupDlg.GetComSpeed());
	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_COMSPEED),buff);
	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_INDICATOR_COMPORT),
					setupDlg.GetComPort());
	m_wndView.SetupComCondition(setupDlg.GetComPort(),setupDlg.GetComSpeed());	

	////////////
	BOOL onoff;
	DWORD flag;

	onoff=(pApp->GetProfileInt(ProfileSection,"receiveenable",1))?TRUE:FALSE;
	flag=(onoff)?MF_CHECKED:MF_UNCHECKED;
	GetMenu()->CheckMenuItem(ID_REnable,flag|MF_BYCOMMAND);
	m_wndView.ReceptionControl(onoff);

	flag=(pApp->GetProfileInt(ProfileSection,"localecho",1))?MF_CHECKED:MF_UNCHECKED;
	GetMenu()->CheckMenuItem(ID_LOCALECHO,flag|MF_BYCOMMAND);

	int sel;
	sel=pApp->GetProfileInt(ProfileSection,"receiveXrate",3);
	if((sel<0)||(sel>=numTrans))
		sel=0;
	PostMessage(WM_COMMAND,TransIDR[sel],0);
		
	sel=pApp->GetProfileInt(ProfileSection,"sendXrate",3);
	if((sel<0)||(sel>=numTrans))
		sel=0;
	PostMessage(WM_COMMAND,TransIDT[sel],0);
}

void CMainFrame::SaveSettings()
{
	CWinApp* pApp = AfxGetApp();
	pApp->WriteProfileInt(ProfileSection,"receiveenable",
			(GetMenu()->GetMenuState(ID_REnable,MF_BYCOMMAND)&MF_CHECKED)?1:0);
	pApp->WriteProfileInt(ProfileSection,"localecho",
			(GetMenu()->GetMenuState(ID_LOCALECHO,MF_BYCOMMAND)&MF_CHECKED)?1:0);
	int i,sel;
	sel=0;
	for(i=0;i<numTrans;i++)
		if(GetMenu()->GetMenuState(TransIDR[i],MF_BYCOMMAND)&MF_CHECKED)
			sel=i;
	pApp->WriteProfileInt(ProfileSection,"receiveXrate",sel);
	sel=0;
	for(i=0;i<numTrans;i++)
		if(GetMenu()->GetMenuState(TransIDT[i],MF_BYCOMMAND)&MF_CHECKED)
			sel=i;
	pApp->WriteProfileInt(ProfileSection,"sendXrate",sel);

	pApp->WriteProfileInt(ProfileSection,"comspeed",setupDlg.GetComSpeed());
	pApp->WriteProfileString(ProfileSection,"comport",setupDlg.GetComPort());
	
}

void CMainFrame::OnSavedafault() 
{
	SaveSettings();
}
