// XrateSL.cpp: CXrateSL NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "sermon.h"
#include "XrateSL.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

struct RegisterInfo { int valid; unsigned int val; };
struct NodeInfo { int valid; RegisterInfo regs[16],regl[16]; };
static NodeInfo *NodeFile=NULL;

int CXrateSL::dispmode=0;

static void ClearNodeInfo(void) 
{
	int i,j;
	for(i=0;i<64;i++)
	{
		NodeFile[i].valid=0;
		for(j=0;j<16;j++)
		{
			NodeFile[i].regs[j].valid=0;
			NodeFile[i].regl[j].valid=0;
			NodeFile[i].regs[j].val=0;
			NodeFile[i].regl[j].val=0;
		}
	}
}

static void DeleteNodeFile(void)
{
	if(NodeFile) delete[] NodeFile;
	NodeFile=NULL;
}

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXrateSL::CXrateSL(CWnd *o,int _id) : CXrate(o)
{
	recvc=0;
	mode=0;
	trmode=0;
	thisID=_id;
	if(NodeFile==NULL) 
	{ NodeFile=new NodeInfo[64];  ClearNodeInfo(); atexit(DeleteNodeFile); }
}

CXrateSL::~CXrateSL()
{

}

static void tolowers(char *s)
{
	char *p;
	for(p=s; *p; p++)
		*p=tolower(*p);
}

enum CID
{
	CIDNOP,
	CIDNOPS,
	CIDReset,
	CIDRequestProfile,
	CIDReplyProfile,
	CIDSetID,
	CIDSetIDReply,

	CIDSet16,
	CIDGet16,
	CIDSet32,
	CIDGet32,
	CIDReply16,
	CIDReply32,

	CIDMRead8,  CIDMRead16,
	CIDMReply8, CIDMReply16,
	CIDMWrite8, CIDMWrite16,
	//CIDMAnd8,   CIDMAnd16,
	//CIDMOr8,    CIDMOr16,
	//CIDMXor8,   CIDMXor16,

	CIDBurst,

	CIDBulkSet,   //0xa0  
	CIDBulkGet,   //0xa1
	CIDBulkReply, //0xa2
};


struct stCmdTable { char *cmd; int cmdID; };
static stCmdTable cmdTable[]=
{
	{ "reset",			CIDReset },
	{ "reqprof",		CIDRequestProfile },
	{ "requestprofile",	CIDRequestProfile },
	{ "repprof",		CIDReplyProfile },
	{ "replyprofile",	CIDReplyProfile },
	{ "setid",          CIDSetID },
	{ "setidreply",     CIDSetIDReply },
	{ "nop",			CIDNOP },
	{ "nops",			CIDNOPS },
	{ "set16",			CIDSet16 },
	{ "get16",			CIDGet16 },
	{ "set32",			CIDSet32 },
	{ "get32",			CIDGet32 },
	{ "reply16",		CIDReply16 },
	{ "reply32",		CIDReply32 },
	{ "read8",			CIDMRead8 },
	{ "read16",			CIDMRead16 },
	{ "write8",			CIDMWrite8 },
	{ "write16",		CIDMWrite16 },
	{ "mreply8",		CIDMReply8 },
	{ "mreply16",		CIDMReply16 },

	{ "burst",			CIDBurst },

	{ "bulkset",        CIDBulkSet },   // bset   <dest> <st> <len> <w0> <w1> <w2> ... 
	{ "bulkget",        CIDBulkGet },   // bget   <dest> <st> <len>
	{ "bulkreply",      CIDBulkReply }, // breply <dest> <st> <len> <w0> <w1> <w2> ...
	{ "bset",        CIDBulkSet },
	{ "bget",        CIDBulkGet },
	{ "breply",      CIDBulkReply },

	{ NULL,				CIDNOP },
};

const int BCOM_NNO=5;
const unsigned char BCOM_CMD=0x20;

static inline int ScanDecHex(char *&s,int &d)
{
	int n;
	char tmp[200];
	if(sscanf(s,"%s%n",tmp,&n)!=1)
		return 0;
	s+=n;
	if((tmp[0]=='0')&&(strchr("xX",tmp[1])!=NULL))
		sscanf(tmp,"%x",&d);
	else
		sscanf(tmp,"%d",&d);

	return 1;
}

char *CXrateSL::XrateTransmit(char *ins,int &len)
{
	char sbuff[256];
	int l,st=0;
	len=0;
	char *top=ins,*next;

	if(strncmp(ins,"shownode",8)==0)
		return XrateTransReport(ins,len);
	if(strncmp(ins,"rawmode",7)==0)
	{ dispmode=1; return 0;}
	if(strncmp(ins,"normalmode",10)==0)
	{ dispmode=0; return 0;}


	while(*top)
	{
		next=strchr(top,';');
		if(next) { *next='\0'; next++; }
		else next=top+strlen(top);
		l=-1;
		XrateTransmitSingle(top,l,sbuff);
		if(l>=0)
		{
			memcpy(sendbuff+st,sbuff,l);
			len+=l;
			st+=l;
		}
		top=next;
	}
	return sendbuff;
}

void CXrateSL::XrateTransmitSingle(char *ins,int &len,char *sbuff)
{
	int i,datalen=0;
	int head=EncodePacket(ins,datalen,sbuff+2);  // data start at +2
	if(head<0) return;
	if(head==0)
	{
		for(i=0;i<datalen;i++)
			sbuff[i]=0;
		len=datalen;
		return;
	}
	else
	{
		sbuff[0]=head;
		sbuff[1]=datalen;
		len=datalen+2;
		return;
	}
	return;
}

int CXrateSL::EncodePacket(char *ins,int &len,char *sbuff)
{
	char cmd[200],dest[200],*tp;
	int cmdlen;
	if(sscanf(ins,"%199s%n",cmd,&cmdlen)!=1)
	{
		//owner->MessageBox("@sł\n(command dest args)","SerialLoop M");
		return -1;
	}
	tolowers(cmd);

	int cmdID,i;
	for(i=0; cmdTable[i].cmd; i++)
		if(strcmp(cmdTable[i].cmd,cmd)==0)
		{
			cmdID=cmdTable[i].cmdID;
			break;
		}
	if(cmdTable[i].cmd==NULL)
	{
		char tmp[300]; sprintf(tmp,"Illegal command '%s'",cmd);
		owner->MessageBox(tmp,"SerialLoop transmit");
		return -1;
	}

	// ʃpPbg͂ŏ
	//
	switch(cmdID)
	{
	case CIDNOP:
		len=1; return 0;
	case CIDNOPS:
		len=32; return 0;

	case CIDBurst:  // o[Xg]vgR
	{
		int val;
		char *p=sbuff,*q=ins+cmdlen;
		for(i=0;i<BCOM_NNO;i++)
		{
			if(ScanDecHex(q,val)!=1)
			{
				owner->MessageBox("'Burst' command without enough params.","SerialLoop transmit");
				len=0;
				return -1;
			}
			sprintf(p,"%c%c%c%c",
					val&0xff,(val>>8)&0xff,(val>>16)&0xff,(val>>24)&0xff);
			p+=4;
		}

	}
		len=BCOM_NNO*4;
		return BCOM_CMD;
	}

	int destID;

	// 揈̂߁Aĕ
	if(sscanf(ins,"%199s %199s%n",cmd,dest,&cmdlen)!=2)
	{
		char tmp[300]; sprintf(tmp,"Syntax error\n%s <destination> args",cmd);  
		owner->MessageBox(tmp,"SerialLoop transmit");
		return -1;
	}
	tolowers(dest);  tolowers(cmd);
	// 搶
	tp=dest;
	if((strcmp(dest,"all")==0)||(strstr(dest,"cast")!=NULL))
		destID=0x80 | thisID;
	else if(strcmp(dest,"this")==0)
		destID=0x40|thisID;
	else if((ScanDecHex(tp,destID)==1)&&(destID>=0)&&(destID<64))
		destID=(destID&0x3f)|0x40;
	else 
	{
		owner->MessageBox("Destination is not collect\n(0-63, all)","SerialLoop transmit");
		return -1;
	}
	// R}h
	char *p;
	int rid,val,bst,blen,bw;
	switch(cmdID)
	{
	case CIDReset:
		sprintf(sbuff,"%c%c",0x00,thisID);
		len=2;
		return destID;
	case CIDRequestProfile:
		sprintf(sbuff,"%c%c",0x02,thisID);
		len=2;
		return destID;
	case CIDReplyProfile:
		p=ins+cmdlen; if(*p) p++;
		len=strlen(p);
		sprintf(sbuff,"%c%c%s",0x03,thisID,p);
		len+=2;
		return destID;
	case CIDSetID:
		p=ins+cmdlen;
		if(ScanDecHex(p,val)!=1) {
			owner->MessageBox("SetID <DEST> <newID>","SerialLoop tx");
			return -1;
		}
		sprintf(sbuff,"%c%c%c",0x04,thisID,val);
		len=3;
		return destID;
	case CIDSetIDReply:
		p=ins+cmdlen;
		ScanDecHex(p,rid);
		if(ScanDecHex(p,val)!=1) {
			owner->MessageBox("SetID <DEST> <oldID> <newID>","SerialLoop tx");
			return -1;
		}
		sprintf(sbuff,"%c%c%c",0x05,rid,val);
		len=3;
		return destID;
	case CIDSet16:
	case CIDReply16:
		p=ins+cmdlen;
		ScanDecHex(p,rid);   rid=rid&0xf;
		if(ScanDecHex(p,val)!=1) {
			owner->MessageBox("Set16 <DEST> <RID> <VAL16>","SerialLoop tx");
			return -1;
		}
		val=val&0xffff;
		sprintf(sbuff,"%c%c%c%c",((cmdID==CIDSet16)?0x20:0x60)|rid,thisID,
						val&0xff,(val>>8)&0xff);
		len=4; return destID;
	case CIDSet32:
	case CIDReply32:
		p=ins+cmdlen;
		ScanDecHex(p,rid);   rid=rid&0xf;
		if(ScanDecHex(p,val)!=1) {
			owner->MessageBox("Set32 <DEST> <RID> <VAL32>","SerialLoop tx");
			return -1;
		}
		val=val&0xffffffff;
		sprintf(sbuff,"%c%c%c%c%c%c",((cmdID==CIDSet32)?0x30:0x70)|rid,thisID,
						val&0xff,(val>>8)&0xff,(val>>16)&0xff,(val>>24)&0xff);
		len=6; return destID;
	
	case CIDGet16:
	case CIDGet32:
		p=ins+cmdlen;
		if(ScanDecHex(p,rid)!=1) {
			owner->MessageBox("Get16/32 <DEST> <RID>","SerialLoop tx");
			return -1;
		}
		rid=rid&0xf;
		sprintf(sbuff,"%c%c",((cmdID==CIDGet16)?0x40:0x50)|rid,thisID);
		len=2; return destID;

	case CIDMRead8:
	case CIDMRead16:
	case CIDMReply8:
	case CIDMReply16:
	case CIDMWrite8:
	case CIDMWrite16:
		{
			int wf=(cmdID==CIDMRead16)||(cmdID==CIDMReply16)||(cmdID==CIDMWrite16);
			p=ins+cmdlen;
			int maddr,val=0;
			if((cmdID!=CIDMRead8)&&(cmdID!=CIDMRead16))
			{
				ScanDecHex(p,maddr);
				if(ScanDecHex(p,val)!=1)
				{
					char __tmpbuff[100];
					sprintf(__tmpbuff,"%s <dest> <Address> <Val> tx",cmd);
					owner->MessageBox(__tmpbuff,"SerialLoop");
					return -1;
				}
			}
			else
			{
				if(ScanDecHex(p,maddr)!=1)
				{
					char __tmpbuff[100];
					sprintf(__tmpbuff,"%s <dest> <Address>",cmd);
					owner->MessageBox(__tmpbuff,"SerialLoop tx");
				}
			}
			// maddr: address, val: value
			sprintf(sbuff,"%c%c%c%c%c%c%c",0,thisID,maddr&0xff,(maddr>>8)&0xff,(maddr>>16)&0xff,
											val&0xff,(val>>8)&0xff);
			switch(cmdID)
			{
			case CIDMRead8:  sbuff[0]=(char )0x80; break;
			case CIDMRead16: sbuff[0]=(char )0x81; break;
			case CIDMReply8: sbuff[0]=(char )0x82; break;
			case CIDMReply16:sbuff[0]=(char )0x83; break;
			case CIDMWrite8: sbuff[0]=(char )0x84; break;
			case CIDMWrite16:sbuff[0]=(char )0x85; break;
			}
			len=6+(wf?1:0);
			return destID;
		}
	case CIDBulkSet:
	case CIDBulkReply:
		p=ins+cmdlen;
		ScanDecHex(p,bst);
		if(ScanDecHex(p,blen)!=1) {
			owner->MessageBox("BulkSet/Reply <DEST> <Start> <Len> <W0> <W1>...","SerialLoop tx");
			return -1;
		}
		sprintf(sbuff,"%c%c%c%c",(cmdID==CIDBulkSet)?0xa0:0xa2,thisID,bst,blen);
		for(i=0;i<blen;i++)
		{
			if(ScanDecHex(p,bw)!=1) {
				owner->MessageBox("BulkSet/Reply: too few data","SerialLoop tx");
				return -1;
			}
			sbuff[4+i*2]=(bw>>8)&0xff;
			sbuff[5+i*2]=(bw)&0xff;
		}
		len=4+blen*2;  return destID;

	case CIDBulkGet:
		p=ins+cmdlen;
		ScanDecHex(p,bst);
		if(ScanDecHex(p,blen)!=1) {
			owner->MessageBox("BulkGet <DEST> <Start> <Len>","SerialLoop tx");
			return -1;
		}
		sprintf(sbuff,"%c%c%c%c",0xa1,thisID,bst,blen);
		len=4; return destID;
	}	
	return -1;
}


char * CXrateSL::XrateTransReport(char *s, int &l)
{
	char tmp[100],cmd[100],tag[100];
	int i,n,j;
	l=XRATETREPORT;
	tolowers(s);
	n=sscanf(s,"%s %s %s",tmp,cmd,tag);
	if(n==1)
	{  // m[h\
		strcpy(sendbuff,"Valid Nodes:   ");
		for(i=0;i<64;i++)
		{
			if(NodeFile[i].valid)
				sendbuff[13+i]='0'+(i%10);
			else
				sendbuff[13+i]='-';
		}
		strcpy(sendbuff+13+64,"\r\n");
		return sendbuff;
	}
	_int64 target=0;
	if(n==2) // w
	{
		for(i=0;i<64;i++)
			target|=(NodeFile[i].valid)?((_int64)1<<i):0;
	}
	if(n==3)
	{
		if(strcmp(tag,"all")==0)
			target=~((_int64)0);
		else
			target=((_int64)1)<<(atoi(tag));
	}

	char *p=sendbuff; *p='\0';
	if(n>1)
	{
		if(strcmp(cmd,"clear")==0)
		{
			ClearNodeInfo();
			return "";
		}
		if(strcmp(cmd,"reg16")==0)
		{
			for(i=0;i<64;i++)
			{
				if((target&((_int64)1<<i))==0) continue;
				sprintf(p,"Node %d(%02X)  16bit registers\r\n",i,i); p=p+strlen(p);
				for(j=0;j<16;j++)
				{
					if(NodeFile[i].regs[j].valid)
						sprintf(p,"% 5u(%04X) ",NodeFile[i].regs[j].val,NodeFile[i].regs[j].val);
					else
						strcpy(p,"-----(----) ");
					p+=strlen(p);
					if((j&7)==7) { strcpy(p,"\r\n"); p+=2; }
				}
			}
			return sendbuff;
		}
		if(strcmp(cmd,"reg32")==0)
		{
			for(i=0;i<64;i++)
			{
				if((target&((_int64)1<<i))==0) continue;
				sprintf(p,"Node %d(%02X)  32bit registers\r\n",i,i); p=p+strlen(p);
				for(j=0;j<16;j++)
				{
					if(NodeFile[i].regl[j].valid)
						sprintf(p,"% 10u(%08X) ",NodeFile[i].regl[j].val,NodeFile[i].regl[j].val);
					else
						strcpy(p,"----------(--------) ");
					p+=strlen(p);
					if((j&3)==3) { strcpy(p,"\r\n"); p+=2; }
				}
			}
			return sendbuff;
		}
	}

	sprintf(sendbuff,"unknown 'shownode ( /clear/reg16/reg32)' command\r\n");
	return sendbuff;
}


enum RMODE
{
	RM_START,
	RM_SYNC,
	RM_SKIP,
	RM_RECV,
};


void CXrateSL::DecodePacket(int cmd,int datalen,unsigned char *data)
{
	int n,j;
	char *lp=reptbuff+strlen(reptbuff);
	// œpPbg͏
	switch(cmd)
	{
	case BCOM_CMD:
		sprintf(lp,"Burst Transfer Packet (%d bytes): \r\n  %n",datalen,&n);
		lp+=n;
		for(j=0;j<BCOM_NNO;j++)
		{
			int val=data[j*4]|(data[j*4+1]<<8)|(data[j*4+2]<<16)|(data[j*4+3]<<24);
			sprintf(lp+j*22,"% 12d(%08X)",val,val);
		}
		strcat(reptbuff,"\r\n");
		return;
		break;
	default:
		;	//Ȃ
	}
	// pPbg܂Ł

	char dest[30];
	if((cmd&0xc0)==0x40) sprintf(dest,"to ID:%02X",cmd&0x3f);
	else if((cmd&0xc0)==0x80) sprintf(dest,"BCAST(by %02X)",cmd&0x3f);
	else sprintf(dest,"Unknown destination %02X",cmd);
	if(datalen==0)
	{
		sprintf(lp,"Unknown VOID packet %s\r\n",dest);
		return;
	}

	int src=data[1]&0x3f;
	NodeFile[src].valid=1;
	unsigned long tick=GetTickCount();
	switch(data[0])
	{
	case 0x00: // rest
		sprintf(lp,"Device reset by ID:%02X %s\r\n",src,dest);
		break;
	case 0x02: // req prof
		sprintf(lp,"Request Profile by ID:%02X %s\r\n",src,dest);
		break;
	case 0x03: // rep prof
		sprintf(lp,"Reply Profile from ID:%02X %s '%*.*s'\r\n",src,dest,
					datalen-2,datalen-2,data+2);
		break;
	case 0x04: // setid
		sprintf(lp,"SetID from ID:%02X %s set to %02X\r\n",src,dest,data[2]);
		break;
	case 0x05: // setidreply
		sprintf(lp,"SetID reply to %s, %02X changed to %02X\r\n",dest,data[1],data[2]);
		break;
	case 0xa1: // bulkget
		sprintf(lp,"BulkGet from ID:%02X %s: S:%d Len:%d\r\n",src,dest,data[2],data[3]);
		break;
	case 0xa0: // bulkset
	case 0xa2: // bulkrep
		sprintf(lp,"%s from ID:%02X %s: S:%d Len:%d> %n",
			(data[0]==0xa0)?"BulkGet":"BulkReply",src,dest,data[2],data[3],&n);
		lp+=n;
		for(j=0;j<data[3];j++)
		{
			n=(((unsigned int)(data[4+j*2]))<<8)|(data[5+j*2]);
			sprintf(lp+j*15,"0x%04X(%5d), ",n,n);
		}
		strcat(lp,"\r\n");
		return;

	default:
		if((data[0]<0x20)||(data[0]>0x8f))
		{
			sprintf(lp,"Unknown packet from ID:%02X %s CMD:%02X: %n",src&0xff,dest,cmd&0xff,&n);
			lp+=n;
			for(j=0;j<datalen;j++)
				sprintf(lp+j*3,"%02X ",data[j]);
			strcat(reptbuff,"\r\n");
			return;
		}
		if((data[0]&0xf0)==0x80) // Memory Operations
		{
			const char *MemOpes[8]={"mread","mreply","mwrite","mand","mor","mxor","m??","m??"};
			int wf=data[0]&1;
			int addr=((unsigned int)(data[2]))|(((unsigned int)(data[3]))<<8)|(((unsigned int)(data[4]))<<16);
			int val=data[5]|(wf?(((unsigned int)(data[6]))<<8):0);
			switch(data[0]&0xfe)
			{
			case 0x80: // read
				sprintf(lp,"%s%d from ID:%02X %s: addr:0x%05X\n",
					MemOpes[(data[0]-0x80)>>1],wf?16:8,src,dest,addr);
			case 0x82: // reply
			case 0x84: // write
			case 0x86: // and
			case 0x88: // or
			case 0x8a: // xor
			case 0x8c: // ??
			case 0x8e: //
				if(wf)
					sprintf(lp,"%s16 from ID:%02X %s: addr:0x%05X val:0x%04X(% 6d)\n",
							MemOpes[(data[0]-0x80)>>1],src,dest,addr,val,val);
				else
					sprintf(lp,"%s8 from ID:%02X %s: addr:0x%05X val:0x%02X(% 4d)\n",
							MemOpes[(data[0]-0x80)>>1],src,dest,addr,val,val);
			}
			return;
		}
		int rid=data[0]&0xf;
		unsigned int val;
		if(datalen==6) val=data[2]|(data[3]<<8)|(data[4]<<16)|(data[5]<<24);
		else           val=data[2]|(data[3]<<8);
		int val16s=val;  if(val16s&0x8000) val16s|=0xffff0000;
		switch(data[0]&0xf0)
		{
		case 0x20:
			if(dispmode)
				sprintf(lp,"S,116,%d,%d,%d,%d,%d\r\n",tick,src,cmd&0x3f,rid,val);
			else
				sprintf(lp,"Set16 Reg.%X to 0x%04X(%5d,% 6d) by ID:%02X %s\r\n",rid,val,val,val16s,src,dest);
			break;
		case 0x30:
			if(dispmode)
				sprintf(lp,"S,132,%d,%d,%d,%d,%d\r\n",tick,src,cmd&0x3f,rid,val);
			else
				sprintf(lp,"Set32 Reg.%X to 0x%08X(%9d) by ID:%02X %s\r\n",rid,val,val,src,dest);
			break;
		case 0x40:
			if(dispmode)
				sprintf(lp,"G,216,%d,%d,%d,%d\r\n",tick,src,cmd&0x3f,rid);
			else
				sprintf(lp,"Get16 Reg.%X by ID:%02X %s\r\n",rid,src,dest);
			break;
		case 0x50:
			if(dispmode)
				sprintf(lp,"G,232,%d,%d,%d,%d\r\n",tick,src,cmd&0x3f,rid);
			else
				sprintf(lp,"Get32 Reg.%X by ID:%02X %s\r\n",rid,src,dest);
			break;
		case 0x60:
			if(dispmode)
				sprintf(lp,"R,316,%d,%d,%d,%d,%d\r\n",tick,src,cmd&0x3f,rid,val);
			else
				sprintf(lp,"Rep16 Reg.%X = 0x%04X(%5d,% 6d) from ID:%02X %s\r\n",rid,val,val,val16s,src,dest);
			NodeFile[src].regs[rid].val=val;
			NodeFile[src].regs[rid].valid=1;
			break;
		case 0x70:
			if(dispmode)
				sprintf(lp,"R,332,%d,%d,%d,%d,%d\r\n",tick,src,cmd&0x3f,rid,val);
			else
				sprintf(lp,"Rep32 Reg.%X = 0x%08X(%9d) from ID:%02X %s\r\n",rid,val,val,src,dest);
			NodeFile[src].regl[rid].val=val;
			NodeFile[src].regl[rid].valid=1;
			break;
		}
	}
}

char *CXrateSL::XrateReceive(char *rcv,int len)
{
	reptbuff[0]='\0';
	int i,j,lastmode;
	if(recvc>250)
	{
		MessageBox(NULL,"Internal error","SerialLoop11",MB_OK);
		recvc=0;
	}
	for(i=0;i<len;i++)
	{
		if(strlen(reptbuff)>1500)
		{
			strcpy(reptbuff,"Report outputbuffer Overflowed: cleared.\r\n");
		}
		lastmode=mode;
		if(recvc==0) 
			mode=RM_START;
		recvbuff[recvc]= rcv[i];  // M
		recvc++;
		switch(mode)
		{
		case RM_START:  // MJn
			if(recvbuff[0]==0)   // NOP
			{ 
				mode=RM_SYNC; 
				strcat(reptbuff,".");
				recvc=0;
				break;
			}
			if(lastmode==RM_SYNC) strcat(reptbuff,"\r\n");
			switch(recvbuff[0]&0xc0)
			{
			case 0xc0:	// \F_ł͓]Ȃ
				mode=RM_SKIP;   trmode=0;
				break;
			case 0x40:
				if((recvbuff[0]&0x3f)==thisID)
				{ mode=RM_RECV; trmode=0; }
				else
				{ mode=RM_SKIP; trmode=1; }
				// ł͑SM
				mode=RM_RECV;
				break;
			case 0x80:
				if((recvbuff[0]&0x3f)==thisID)
				{ mode=RM_SKIP; trmode=0; }  // łBCAST
				else
				{ mode=RM_RECV; trmode=1; }
				mode=RM_RECV;
				break;
			case 0x00:  // 
				switch(recvbuff[0]&0x3f)
				{
				case BCOM_CMD:
					mode=RM_RECV;  trmode=1;
					break;
				default:
					mode=RM_SKIP;  // ߂łȂ΃XLbv
					break;
				}
				break;
			}
			break;  // PoCgځI
		case RM_SKIP:
			if((recvc>1)&&(recvc==recvbuff[1]+2))
			{  // SKIP
				char *lp=reptbuff; while(*lp) lp++;
				sprintf(lp,"Unknown Special packet 0x%02X (%d bytes): ",recvbuff[0],recvc);
				while(*lp) lp++;
				for(j=0;j<recvc;j++)
					sprintf(lp+j*3,"%02X ",recvbuff[j]);
				strcat(reptbuff,"\r\n");
				recvc=0;
			}
			break;
		case RM_RECV:
			if((recvc>1)&&(recvc==recvbuff[1]+2))
			{  // RECV
				DecodePacket(recvbuff[0],recvbuff[1],recvbuff+2);
				recvc=0;
			}
			break;
		}
		if(trmode) { ; } // ]
	}
	return reptbuff;
}


// ======================================================================
//     SerialLoop Ver 1.1
// ======================================================================

static unsigned char CalculateSL11Sum(unsigned char *d,int l)
{
	int i;
	unsigned char s=0,x=0;
	for(i=0;i<l;i++)
	{
		s+=d[i];
		x^=d[i];
	}
	return s^(x<<4);
}

void CXrateSL11::XrateTransmitSingle(char *ins,int &len,char *sbuff)
{
	int i,datalen=0;
	int head=EncodePacket(ins,datalen,sbuff+3);  // data start at +2
	if(head<0) return;
	if(head==0)
	{
		for(i=0;i<datalen;i++)
			sbuff[i]=0;
		len=datalen;
		return;
	}
	else
	{
		sbuff[0]=head;
		sbuff[1]=datalen;
		sbuff[2]=~datalen;
		len=datalen+4;
		sbuff[datalen+3]=CalculateSL11Sum((unsigned char *)(sbuff+3),datalen);	
		return;
	}
	return;
}


char *CXrateSL11::XrateReceive(char *rcv,int len)
{
	reptbuff[0]='\0';
	int i,j,n,lastmode;
	if(recvc>100)
	{
		MessageBox(NULL,"Internal Error","SerialLoop11::XrateReceive",MB_OK);
		recvc=0;
	}
	for(i=0;i<len;i++)
	{
		if(strlen(reptbuff)>1500)
		{
			strcpy(reptbuff,"Report outputbuffer Overflowed: cleared.\r\n");
		}
		lastmode=mode;
		if(recvc==0) 
			mode=RM_START;
		recvbuff[recvc]= rcv[i];  // M
		recvc++;

		// Packet length error detection
#define NEGB(a) ((~(a))&0xff)
		if(recvc==3)
		{
			if(recvbuff[1]!=NEGB(recvbuff[2]))
			{
				char *lp=reptbuff+strlen(reptbuff);
				sprintf(lp,"Recv:Packet length error %02X-%02X %n",recvbuff[1],recvbuff[2],&n);
				lp+=n;
				if((recvbuff[1]<SL11ML)&&((NEGB(recvbuff[2]))>=SL11ML))  // illegal [2]
				{
					recvbuff[2]=NEGB(recvbuff[1]); 
					sprintf(lp,"Recovered to %02X-%02X ",recvbuff[1],recvbuff[2]); 
				}
				else if((recvbuff[1]>=SL11ML)&&((NEGB(recvbuff[2]))<SL11ML))  // illegal [1]
				{  
					recvbuff[1]=NEGB(recvbuff[2]); 
					sprintf(lp,"Recovered to %02X-%02X ",recvbuff[1],recvbuff[2]); 
				}
				else if(recvbuff[1]<SL11ML)
				{
					recvbuff[2]=NEGB(recvbuff[1]);
					sprintf(lp,"Cannot recover, use %02X ",recvbuff[1]); 
				}
				else if((NEGB(recvbuff[2]))<SL11ML)
				{
					recvbuff[1]=NEGB(recvbuff[2]);
					sprintf(lp,"Cannot recover, use %02X ",recvbuff[1]); 
				}
				else
				{
					recvbuff[1]=0;
					sprintf(lp,"Cannot recover, Use 'nops' to recover connection \n"); 
				}
			}
		}
		switch(mode)
		{
		case RM_START:  // MJn
			if(recvbuff[0]==0)   // NOP
			{ 
				mode=RM_SYNC; 
				strcat(reptbuff,".");
				recvc=0;
				break;
			}
			if(lastmode==RM_SYNC) strcat(reptbuff,"\r\n");
			switch(recvbuff[0]&0xc0)
			{
			case 0xc0:	// \F_ł͓]Ȃ
				mode=RM_SKIP;   trmode=0;
				break;
			case 0x40:
				if((recvbuff[0]&0x3f)==thisID)
				{ mode=RM_RECV; trmode=0; }
				else
				{ mode=RM_SKIP; trmode=1; }
				// ł͑SM
				mode=RM_RECV;
				break;
			case 0x80:
				if((recvbuff[0]&0x3f)==thisID)
				{ mode=RM_SKIP; trmode=0; }  // łBCAST
				else
				{ mode=RM_RECV; trmode=1; }
				mode=RM_RECV;
				break;
			case 0x00:  // 
				switch(recvbuff[0]&0x3f)
				{
				case BCOM_CMD:
					mode=RM_RECV;  trmode=1;
					break;
				default:
					mode=RM_SKIP;  // ߂łȂ΃XLbv
					break;
				}
				break;
			}
			break;  // PoCgځI
		case RM_SKIP:
			if(recvc>2)
			{
				if(recvc==recvbuff[1]+4)
				{  // SKIP
					char *lp=reptbuff+strlen(reptbuff);
					sprintf(lp,"Unknown Special packet 0x%02X (%d bytes): ",recvbuff[0],recvc);
					while(*lp) lp++;
					for(j=0;j<recvc;j++)
						sprintf(lp+j*3,"%02X ",recvbuff[j]);
					strcat(reptbuff,"\r\n");
					recvc=0;
				}
			}
			break;
		case RM_RECV:
			if(recvc>2)
			{
                if(recvc==recvbuff[1]+4)
				{  // RECV
					if(CalculateSL11Sum(recvbuff+3,recvbuff[1])!=recvbuff[recvc-1])
					{
						char *lp=reptbuff+strlen(reptbuff);
						sprintf(lp,"Checksum Error packet 0x%02X (%d bytes): %n",recvbuff[0],recvc,&n);
						lp+=n;
						for(j=0;j<recvc;j++)
							sprintf(lp+j*3,"%02X ",recvbuff[j]);
						strcat(lp,"\r\n Cand: ");
					}
					DecodePacket(recvbuff[0],recvbuff[1],recvbuff+3);
					recvc=0;
				}
				break;
			}
		}
		if(trmode) { ; } // ]
	}
	return reptbuff;
}
